float4x4 WVP : WORLDVIEWPROJECTION;
float4x4 World : WORLD;

float4 Kolor : COLOR = float4(1,1,0,1);
bool MapujKolorWerteksu = false;

bool OswietleniePerPixel = true;

float4 Ce : COLOR = float4(0,0,0,1);
float4 Ca : COLOR = float4(0.1,0.1,0.1,1);
float4 Cd : COLOR = float4(0.5,0.5,0.5,1);
//float4 Cd : COLOR = float4(0,0,0,1);
float4 Cs : COLOR = float4(1,1,1,1);

float4 Wa = float4(1,1,1,1);
float4 Wd = float4(1,1,1,1);
float4 Ws = float4(1,1,1,1);
float ns = 10;

float3 PozycjaZrodlaSwiatla = float3(1,1,1);
float3 PolozenieKamery : CAMERAPOSITION = float3(0,0,1);

bool TlumienieOswietlenia = false;
float3 WspolczynnikTlumienia = float3(0,0,0.1); //staly,liniowy,kwadratowy (C,L,Q)

texture2D Tekstura;
sampler ProbnikTekstury = sampler_state
{
	texture = <Tekstura>;
	magfilter = LINEAR;
	minfilter = LINEAR;
	mipfilter = LINEAR;
	addressU = CLAMP;
	addressV = CLAMP;
};

//http://celestia.h-schmidt.net/earth-vt/

texture2D MapaNormalnych;
sampler ProbnikMapyNormalnych = sampler_state
{
	texture = <MapaNormalnych>;
	magfilter = LINEAR;
	minfilter = LINEAR;
	mipfilter = LINEAR;
	addressU = CLAMP;
	addressV = CLAMP;
};

texture2D MapaRozblysku;
sampler ProbnikMapyRozblysku = sampler_state
{
	texture = <MapaRozblysku>;
	magfilter = LINEAR;
	minfilter = LINEAR;
	mipfilter = LINEAR;
	addressU = CLAMP;
	addressV = CLAMP;
};

struct Dane_PozycjaNormalnaWspTeksturowania
{
	float4 Polozenie : POSITION0;
	float3 Normalna : NORMAL0;
	float2 WspTeksturowania : TEXCOORD0;
};

struct Dane_PozycjaNormalnaWspTeksturowaniaStycznaBinormalna
{
	float4 Polozenie : POSITION0;
	float3 Normalna : NORMAL0;
	float2 WspTeksturowania : TEXCOORD0;

	float3 Styczna : TEXCOORD3; //TANGENT0;
	float3 Binormalna : TEXCOORD4; //BINORMAL0;
};


struct Dane_PozycjaKolor
{
	float4 Polozenie : POSITION0;
	float4 Kolor : COLOR0;
};

struct Dane_PozycjaKolorNR
{
	float4 Polozenie : POSITION0;
	float4 Kolor : COLOR0;
	float3 N : TEXCOORD1;
	float3 R : TEXCOORD2;

	float2 WspTeksturowania : TEXCOORD0;
};

struct Dane_PozycjaKolorNRStycznaBinormalna
{
	float4 Polozenie : POSITION0;
	float4 Kolor : COLOR0;
	float3 N : TEXCOORD1;
	float3 R : TEXCOORD2;

	float2 WspTeksturowania : TEXCOORD0;

	float3 Styczna : TEXCOORD3; //TANGENT0;
	float3 Binormalna : TEXCOORD4; //BINORMAL0;
};


float tlumienie(float odleglosc)
{
	if(!TlumienieOswietlenia) return 1;
	else
	{
		return 1.0/(WspolczynnikTlumienia[0]+
		            WspolczynnikTlumienia[1]*odleglosc+
					WspolczynnikTlumienia[2]*odleglosc*odleglosc);
	}
}

float4 ObliczKolor(float4 kolor :COLOR,float3 N,float3 R,float2 WspTeksturowania)
{
	float3 odleglosc=PozycjaZrodlaSwiatla-R;
	float3 L=normalize(odleglosc);
	float dotLN=saturate(dot(L,N));	
	float3 O = 2*dotLN*N-L;
	float3 V = normalize(PolozenieKamery-R);
	float dotOVn = saturate(pow(saturate(dot(O,V)),ns));

	//do poprawy
	float4 _Ce=Ce;
	float4 _Ca=Ca;
	float4 _Cd=Cd;
	if(MapujKolorWerteksu)
	{
		_Ce=kolor;
		_Ca=kolor;
		_Cd=kolor;
	}

	//float4 kolorTekstury=tex2D(ProbnikTekstury,WspTeksturowania);
	float4 kolorTekstury=float4(0.5,0.5,0.5,1);
	float4 Wa=kolorTekstury;
	float4 Wd=kolorTekstury;

	float4 Kolor=saturate(_Ce);
	Kolor+=saturate(Wa*_Ca);
	Kolor+=saturate(Wd*_Cd*dotLN);	
	float wspTlumieniaRozblysku=0.3; //specular na ziemi wzgledem oceanu
	float4 _Ws=
		wspTlumieniaRozblysku*float4(1,1,1,1)+
		(1-wspTlumieniaRozblysku)*tex2D(ProbnikMapyRozblysku,WspTeksturowania);	
	Kolor+=saturate(_Ws*Cs*dotOVn);
	Kolor=saturate(tlumienie(odleglosc)*Kolor);
	return Kolor;
}

//Dane_PozycjaKolor VS(float4 Polozenie : POSITION0)
//Dane_PozycjaKolor VS(Dane_PozycjaNormalnaWspTeksturowania input)
Dane_PozycjaKolorNRStycznaBinormalna VS(Dane_PozycjaNormalnaWspTeksturowaniaStycznaBinormalna input)
{
	//Dane_PozycjaKolor output;
	//output.Polozenie=mul(input.Polozenie,WVP);
	//output.Kolor.rgb=abs(input.Normalna);
	//output.Kolor.a=1;

	float3 R=mul(input.Polozenie,World).xyz;	
	float3 N=mul(input.Normalna,World);
	
	Dane_PozycjaKolorNRStycznaBinormalna output;
	output.Polozenie=mul(input.Polozenie,WVP);
	//output.Kolor=(!OswietleniePerPixel)?ObliczKolor(Kolor,N,R,input.WspTeksturowania):Kolor;
	output.Kolor=Kolor;
	output.N=N;
	output.R=R;

	output.WspTeksturowania=input.WspTeksturowania;

	output.Styczna=input.Styczna;
	output.Binormalna=input.Binormalna;

	return output;
}

//float4 PS(Dane_PozycjaKolor input) : COLOR0
float4 PS(Dane_PozycjaKolorNRStycznaBinormalna input) : COLOR0
{		
	//odczytywanie normalnej z mapy normalnych
	float3 NormalnaLokalnyNaSferze=tex2D(ProbnikMapyNormalnych,input.WspTeksturowania)*2-1;
	float3x3 Orientacja=float3x3(input.Styczna,input.Binormalna,input.N); //tu musi byc normalna w ukladzie odniesienia sceny
	input.N=normalize(mul(NormalnaLokalnyNaSferze,Orientacja));

	//return input.Kolor;
	return OswietleniePerPixel?ObliczKolor(input.Kolor,input.N,input.R,input.WspTeksturowania):input.Kolor;
}

Technique technika
{
	Pass przebieg
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}